/*  Using_the_R4_DAC_to_gen_a_sinewave.ino
 *  A sketch for using the DAC in the Arduino R4 Minima
 *  to generate a sine waveform.
 *  Written by Jim Rowe for Silicon Chip, on the 29th September 2023.
 *  Adapted from a sketch by 'daueb'. Last revised at 2:50 pm
 *  Note that the DAC's output appears at the A0 pin.
 *  Also although the DAC is described as having a resolution of 12 bits,
 *  it has a default resolution of 8 bits. This can only be changed by using
 *  the instruction analogWriteResolution(12). We use the default resolution here.
 */

 int Ampl = 100;  // the peak amplitude
 float deg = 0;     // the degrees per sample
 float degMult;      // multiplier
 
void setup()
{
  Serial.begin(9600);   // then start up serial comms to PC at 9600 baud
  while(!Serial){}  // then wait until R4 serial port is awake
  Serial.println("This sketch is for using the Arduino R4 Minima's DAC to generate");
  Serial.println("a smooth sine waveform");
}

void loop()
{
  for (deg =-180; deg<180; deg+=5)
  {
    degMult = sin(deg * 3.14159/180.0);
    analogWrite(A0, Ampl * (1 + degMult));  // then send it to the DAC
    delayMicroseconds(2000);
  }
}
